<div class="card-body">

<?php if (!$empty) : ?>

<style>
/* ================= DESKTOP ================= */
.table thead th{
    text-align:center;
    font-weight:700;
    background:#0d6efd;
    color:#fff;
    vertical-align:middle;
}

.table tbody td{
    text-align:center;
    vertical-align:middle;
}

.table tbody td.nama-col{
    text-align:left;
    font-weight:600;
}

/* ================= MOBILE CARD ================= */
.mobile-card{
    border-radius:12px;
    overflow:hidden;
}

.mobile-header{
    background:#0d6efd;
    color:#fff;
    padding:10px 14px;
    font-weight:700;
}

.mobile-body{
    padding:12px 14px;
}

.mobile-row{
    display:grid;
    grid-template-columns: auto 10px 1fr;
    gap:6px;
    font-size:.85rem;
    margin-bottom:4px;
}

.mobile-row span:first-child{
    font-weight:600;
    color:#555;
}

.mobile-actions{
    display:flex;
    gap:8px;
    padding:10px 14px;
    background:#f8f9fa;
}

.mobile-actions .btn{
    flex:1;
    font-size:.8rem;
}
</style>

<!-- ===================== -->
<!-- DESKTOP TABLE -->
<!-- ===================== -->
<div class="table-responsive d-none d-md-block">
    <table id="siswaTable" class="table table-hover display nowrap w-100">
        <thead>
            <tr>
                <th width="20">
                    <input type="checkbox" id="checkAll">
                </th>
                <th>No</th>
                <th>NIS</th>
                <th class="text-start">Nama Siswa</th>
                <th>Jenis Kelamin</th>
                <th>Kelas</th>
                <th>Jurusan</th>
                <th>No HP</th>
                <th>Unique Code</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $i=1; foreach($data as $value): ?>
            <tr>
                <td>
                    <input type="checkbox" class="check-item" value="<?= $value['id_siswa']; ?>">
                </td>
                <td><?= $i++; ?></td>
                <td><?= $value['nis']; ?></td>
                <td class="nama-col"><?= $value['nama_siswa']; ?></td>
                <td><?= $value['jenis_kelamin']; ?></td>
                <td><?= $value['kelas']; ?></td>
                <td><?= $value['jurusan']; ?></td>
                <td><?= $value['no_hp']; ?></td>
                <td><?= $value['unique_code']; ?></td>
                <td>
                    <div class="d-flex justify-content-center gap-1">
                        <a href="<?= base_url('admin/siswa/edit/'.$value['id_siswa']); ?>" class="btn btn-primary btn-sm">
                            <i class="material-icons">edit</i>
                        </a>
                        <form action="<?= base_url('admin/siswa/delete/'.$value['id_siswa']); ?>" method="post" class="m-0">
                            <?= csrf_field(); ?>
                            <input type="hidden" name="_method" value="DELETE">
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Hapus data?')">
                                <i class="material-icons">delete_forever</i>
                            </button>
                        </form>
                        <a href="<?= base_url('admin/qr/siswa/'.$value['id_siswa'].'/download'); ?>" class="btn btn-success btn-sm">
                            <i class="material-icons">qr_code</i>
                        </a>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- ===================== -->
<!-- MOBILE CARD -->
<!-- ===================== -->
<div class="d-block d-md-none mt-3">
<?php foreach($data as $value): ?>
    <div class="card mobile-card mb-3 shadow-sm">

        <!-- BARIS 1 -->
        <div class="mobile-header">
            <?= $value['nama_siswa']; ?>
        </div>

        <!-- BARIS 2 -->
        <div class="mobile-body">
            <div class="mobile-row">
                <span>NIS</span><span>:</span><span><?= $value['nis']; ?></span>
            </div>
            <div class="mobile-row">
                <span>Jenis Kelamin</span><span>:</span><span><?= $value['jenis_kelamin']; ?></span>
            </div>
            <div class="mobile-row">
                <span>Kelas</span><span>:</span><span><?= $value['kelas']; ?></span>
            </div>
            <div class="mobile-row">
                <span>Jurusan</span><span>:</span><span><?= $value['jurusan']; ?></span>
            </div>
            <div class="mobile-row">
                <span>No HP</span><span>:</span><span><?= $value['no_hp']; ?></span>
            </div>
            <div class="mobile-row">
                <span>Unique Code</span><span>:</span><span><?= $value['unique_code']; ?></span>
            </div>
        </div>

        <!-- BARIS 3 -->
        <div class="mobile-actions">
            <a href="<?= base_url('admin/siswa/edit/'.$value['id_siswa']); ?>" class="btn btn-outline-primary">
                <i class="material-icons">edit</i>
            </a>
            <form action="<?= base_url('admin/siswa/delete/'.$value['id_siswa']); ?>" method="post" class="flex-fill">
                <?= csrf_field(); ?>
                <input type="hidden" name="_method" value="DELETE">
                <button class="btn btn-outline-danger w-100" onclick="return confirm('Hapus data?')">
                    <i class="material-icons">delete</i>
                </button>
            </form>
            <a href="<?= base_url('admin/qr/siswa/'.$value['id_siswa'].'/download'); ?>" class="btn btn-outline-success">
                <i class="material-icons">qr_code</i>
            </a>
        </div>

    </div>
<?php endforeach; ?>
</div>

<?php else: ?>
<div class="text-center text-danger fw-bold">Data tidak ditemukan</div>
<?php endif; ?>

</div>

<!-- DATATABLE -->
<script>
$(document).ready(function () {
    if (window.innerWidth >= 768) {
        $('#siswaTable').DataTable({
            responsive:true,
            language:{
                search:"Cari:",
                emptyTable:"Data tidak ditemukan"
            }
        });
    }

    $('#checkAll').on('click', function(){
        $('.check-item').prop('checked', this.checked);
    });
});
</script>
